import { Controller } from '@hotwired/stimulus';
import { createRoot } from 'react-dom/client';
import React from 'react';
import { BrowserRouter as Router } from 'react-router-dom';
import App from './react/front/App';
import { QueryClient, QueryClientProvider } from '@tanstack/react-query';

/* stimulusFetch: 'lazy' */
export default class extends Controller {
    static values = {
      siteUrl: String,
      //user: Object
    }

    connect() {
        
        // Create root and render the React app
        const root = createRoot(this.element);
        
        // Get the base path from the current URL
        const basePath = this.siteUrlValue;
        
        // Create a single QueryClient instance for React Query
        const queryClient = new QueryClient();
        
        // Set the base path globally for API calls
        window.__BASE_PATH__ = basePath;
        
        //Wrap the Dashboard with Router and pass any necessary props
        root.render(
            <React.StrictMode>
                <QueryClientProvider client={queryClient}>
                    <Router basename={basePath}>
                        <App />
                    </Router>
                </QueryClientProvider>
            </React.StrictMode>
        );
    }
    
}




// import { Controller } from '@hotwired/stimulus';
// import { createRoot } from 'react-dom/client';
// import React from 'react';
// import { BrowserRouter as Router } from 'react-router-dom';
// import App from './react/front/App';
// import { QueryClient, QueryClientProvider } from '@tanstack/react-query';

// /* stimulusFetch: 'lazy' */
// export default class extends Controller {
//     static values = {
//       siteUrl: String,
//       //user: Object
//     }

//     connect() {
//         console.log('Front controller')
        
//         // Create a wrapper div for React to avoid conflicts with Stimulus
//         const wrapper = document.createElement('div');
//         this.element.appendChild(wrapper);
        
//         // Create root and render the React app
//         const root = createRoot(wrapper);
        
//         // Get the base path from the current URL
//         const basePath = this.siteUrlValue;
        
//         // Create a single QueryClient instance for React Query
//         const queryClient = new QueryClient();
        
//         //Wrap the Dashboard with Router and pass any necessary props
//         root.render(
//             <React.StrictMode>
//                 <QueryClientProvider client={queryClient}>
//                     <Router basename={basePath}>
//                         <App />
//                     </Router>
//                 </QueryClientProvider>
//             </React.StrictMode>
//         );
//     }
    
// }
