import React from 'react';
import { Routes, Route } from 'react-router-dom';
import Layout from './components/layout/Layout';

// Pages
import Home from './pages/Home';
import About from './pages/About';
import CV from './pages/CV';
import Showreel from './pages/Showreel';
import VoiceReel from './pages/VoiceReel';
import Gallery from './pages/Gallery';
import Contact from './pages/Contact';

const App = () => {
    return (
        <Layout>
            <Routes>
                <Route path="/" element={<Home />} />
                <Route path="/about" element={<About />} />
                <Route path="/cv" element={<CV />} />
                <Route path="/showreel" element={<Showreel />} />
                <Route path="/voice-reel" element={<VoiceReel />} />
                <Route path="/gallery" element={<Gallery />} />
                <Route path="/contact" element={<Contact />} />
            </Routes>
        </Layout>
    );
}

export default App;
