import React from 'react';
import { Link, useLocation } from 'react-router-dom';

const Header = () => {
    const location = useLocation();
    
    const navItems = [
        { name: 'Home', path: '/' },
        { name: 'About', path: '/about' },
        { name: 'CV', path: '/cv' },
        { name: 'Showreel', path: '/showreel' },
        { name: 'Voice Reel', path: '/voice-reel' },
        { name: 'Gallery', path: '/gallery' },
        { name: 'Contact', path: '/contact' }
    ];
    
    return (
        <header className="fixed top-0 left-0 right-0 z-50 bg-black/80 backdrop-blur-sm">
            <nav className="container mx-auto px-6 py-4">
                <div className="flex items-center justify-between">
                    <Link to="/" className="text-white text-lg font-semibold tracking-wide">
                        Ava Carter
                    </Link>
                    
                    <ul className="flex items-center gap-8">
                        {navItems.map((item) => (
                            <li key={item.path}>
                                <Link
                                    to={item.path}
                                    className={`text-sm transition-colors ${
                                        location.pathname === item.path
                                            ? 'text-white font-medium'
                                            : 'text-gray-400 hover:text-white'
                                    }`}
                                >
                                    {item.name}
                                </Link>
                            </li>
                        ))}
                    </ul>
                </div>
            </nav>
        </header>
    );
};

export default Header;
