import React from 'react';
import { Button } from '@/components/ui/button';

const About = () => {
    return (
        <div className="bg-black text-white">
            {/* Hero Section */}
            <section className="min-h-[40vh] flex flex-col items-center justify-center px-6 py-20">
                <h1 className="text-4xl lg:text-5xl font-light mb-4">About Me</h1>
                <div className="w-32 h-0.5 bg-white"></div>
            </section>

            {/* Beach Photo Section */}
            <section className="w-full">
                <img 
                    src="https://placehold.co/1920x800/5a5a5a/aaaaaa?text=Beach+Portrait" 
                    alt="Ava Carter on Beach"
                    className="w-full h-[500px] object-cover"
                />
            </section>

            {/* Bio Text Section */}
            <section className="bg-[#1a1a1a] py-16">
                <div className="container mx-auto px-6 max-w-4xl space-y-8 text-white">
                    <p className="text-xl lg:text-2xl font-light leading-relaxed">
                        Ava Carter is a London-based actor trained at the 
                        Kingsford Studio (Advanced Screen Acting).
                    </p>
                    
                    <p className="text-base lg:text-lg text-gray-300 leading-relaxed">
                        Recent work includes <span className="font-medium">Quiet Hours</span> (dir. Jamie Wells) 
                        and <span className="font-medium">Midnight Platform</span> for Silver Van Productions.
                    </p>
                    
                    <p className="text-base lg:text-lg text-gray-300 leading-relaxed">
                        A versatile performer with an understated on-screen 
                        presence, Ava plays from thoughtful professional to 
                        conflicted lead.
                    </p>
                </div>
            </section>

            {/* Profile & Details Section */}
            <section className="grid lg:grid-cols-2 gap-0">
                {/* Left Side - Headshot */}
                <div className="relative bg-[#0a0a0a]">
                    <img 
                        src="https://placehold.co/600x800/2a2a2a/777777?text=Professional+Headshot" 
                        alt="Ava Carter Professional Headshot"
                        className="w-full h-full object-cover"
                    />
                </div>
                
                {/* Right Side - Details */}
                <div className="bg-white text-black flex flex-col justify-center px-8 lg:px-16 py-20">
                    <div className="space-y-8">
                        <div>
                            <h3 className="text-sm font-semibold text-gray-600 mb-3">BASE</h3>
                            <p className="text-lg">Neutral British</p>
                        </div>
                        
                        <div>
                            <h3 className="text-sm font-semibold text-gray-600 mb-3">ACCENTS</h3>
                            <p className="text-lg">RP, London, General American</p>
                        </div>
                        
                        <div className="flex gap-4 pt-6">
                            <Button 
                                variant="default" 
                                className="bg-black text-white hover:bg-gray-800"
                                onClick={() => window.open('https://imdb.com', '_blank')}
                            >
                                IMDB
                            </Button>
                            <Button 
                                variant="default" 
                                className="bg-black text-white hover:bg-gray-800"
                                onClick={() => window.open('https://spotlight.com', '_blank')}
                            >
                                SPOTLIGHT
                            </Button>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    );
};

export default About;
