import React from 'react';
import { Button } from '@/components/ui/button';

const Home = () => {
    const credits = [
        {
            title: 'The Fifth Wave',
            role: 'Lead Role',
            year: '2016',
            director: 'J Blakeson',
            production: 'Columbia Pictures'
        },
        {
            title: 'The Grand Hotel',
            role: 'Supporting',
            year: '2019',
            director: 'M. Williams',
            production: 'Netflix Studios'
        },
        {
            title: 'The Fifth Wave',
            role: 'Lead Role',
            year: '2016',
            director: 'J Blakeson',
            production: 'Columbia Pictures'
        },
        {
            title: 'The Grand Hotel',
            role: 'Supporting',
            year: '2019',
            director: 'M. Williams',
            production: 'Netflix Studios'
        }
    ];

    const awards = [
        'Audie 20, "Title" - TV Award',
        'Audie 21, "Title" - TV Award',
        'Audie 22, "Title" - TV Award'
    ];

    return (
        <div className="bg-black text-white">
            {/* Hero Section */}
            <section className="min-h-screen grid lg:grid-cols-2 gap-0">
                {/* Left Side - Text */}
                <div className="bg-[#0a0a0a] flex flex-col justify-center px-8 lg:px-16 py-20">
                    <h1 className="text-4xl lg:text-5xl xl:text-6xl font-light leading-tight mb-8">
                        Grounded, natural<br />
                        performances<br />
                        for Film, TV, Theatre,<br />
                        Commercial
                    </h1>
                    
                    <div className="space-y-4 text-gray-400 text-sm">
                        <p>Represented: North of Watford; Agent</p>
                        <p>
                            <a href="#" className="hover:text-white transition-colors">
                                Watch showreel
                            </a>
                        </p>
                    </div>
                </div>
                
                {/* Right Side - Image */}
                <div className="relative">
                    <img 
                        src="https://placehold.co/800x1200/2a2a2a/666666?text=Headshot" 
                        alt="Ava Carter Headshot"
                        className="w-full h-full object-cover"
                    />
                </div>
            </section>

            {/* About Section */}
            <section className="bg-white text-black py-20">
                <div className="container mx-auto px-6 max-w-4xl">
                    <h2 className="text-3xl lg:text-4xl font-light text-center mb-8">
                        Ava Carter is a London-based<br />
                        actor trained at the Kingsford<br />
                        Studio (Advanced Screen Acting).
                    </h2>
                    
                    <div className="prose prose-lg mx-auto text-center text-gray-700 space-y-4">
                        <p>
                            Known for her ability to bring "lived through" vulnerability and strength, she draws 
                            on deep emotional grounding from her training in both method acting and improvisation. 
                            Her performances feel authentic, nuanced, and remarkably human.
                        </p>
                        <p>
                            Originally from [Location], Ava made the move to London to pursue her acting career, 
                            studying at the renowned Kingsford Studio. She is passionate about storytelling that 
                            challenges audiences and showcases the complexity of the human experience.
                        </p>
                    </div>
                </div>
            </section>

            {/* Quote/Image Section */}
            <section className="relative h-[600px] overflow-hidden">
                <img 
                    src="https://placehold.co/1920x600/4a4a4a/999999?text=Beach+Scene" 
                    alt="Quote Background"
                    className="absolute inset-0 w-full h-full object-cover"
                />
                <div className="absolute inset-0 bg-black/40 flex items-center justify-center">
                    <div className="text-center text-white z-10 px-6">
                        <p className="text-2xl lg:text-3xl font-light italic mb-4">
                            "I'm in it to express myself the way everything<br />
                            else does"
                        </p>
                        <p className="text-sm text-gray-400">- Ava Carter</p>
                    </div>
                </div>
            </section>

            {/* Selected Credits Section */}
            <section className="bg-[#0a0a0a] py-20">
                <div className="container mx-auto px-6">
                    <div className="text-center mb-16">
                        <h2 className="text-3xl lg:text-4xl font-light mb-2">Selected Credits</h2>
                        <div className="w-24 h-0.5 bg-white mx-auto mt-4"></div>
                    </div>
                    
                    <div className="grid md:grid-cols-2 lg:grid-cols-2 gap-6 max-w-5xl mx-auto mb-12">
                        {credits.map((credit, index) => (
                            <div 
                                key={index} 
                                className="bg-[#1a1a1a] border border-gray-800 p-6 rounded-sm hover:border-gray-700 transition-colors"
                            >
                                <h3 className="text-xl font-medium mb-2">{credit.title}</h3>
                                <p className="text-gray-400 text-sm mb-1">{credit.role} - {credit.year}</p>
                                <p className="text-gray-500 text-sm">Dir: {credit.director}</p>
                                <p className="text-gray-500 text-sm">{credit.production}</p>
                            </div>
                        ))}
                    </div>
                    
                    <div className="text-center">
                        <Button 
                            variant="outline" 
                            className="bg-transparent border-white text-white hover:bg-white hover:text-black transition-all"
                        >
                            View Full List
                        </Button>
                    </div>
                </div>
            </section>

            {/* Awards Section */}
            <section className="min-h-[600px] grid lg:grid-cols-2 gap-0">
                {/* Left Side - Awards List */}
                <div className="bg-white text-black flex flex-col justify-center px-8 lg:px-16 py-20">
                    <h2 className="text-3xl lg:text-4xl font-light mb-12">Awards</h2>
                    
                    <ul className="space-y-6 text-lg">
                        {awards.map((award, index) => (
                            <li key={index} className="text-gray-700">
                                {award}
                            </li>
                        ))}
                    </ul>
                </div>
                
                {/* Right Side - Performance Image */}
                <div className="relative">
                    <img 
                        src="https://placehold.co/800x800/3a3a3a/888888?text=Stage+Performance" 
                        alt="Theater Performance"
                        className="w-full h-full object-cover"
                    />
                </div>
            </section>
        </div>
    );
};

export default Home;
