@echo off
REM Authentication System Quick Start Script for Windows
REM This script helps you set up the authentication system quickly

echo ================================
echo Authentication System Setup
echo ================================
echo.

REM Step 1: Install composer dependencies
echo Step 1: Installing Composer dependencies...
call composer require symfonycasts/verify-email-bundle
if %errorlevel% neq 0 (
    echo [ERROR] Failed to install dependencies
    exit /b 1
)
echo [OK] Composer dependencies installed
echo.

REM Step 2: Check if .env.local exists
if not exist .env.local (
    echo Step 2: Creating .env.local...
    
    REM Generate a random secret
    for /f "delims=" %%i in ('php -r "echo bin2hex(random_bytes(32));"') do set SECRET=%%i
    
    (
        echo ###^> Authentication System Configuration ###
        echo.
        echo # Database ^(update with your credentials^)
        echo DATABASE_URL="mysql://user:password@127.0.0.1:3306/dbname?serverVersion=8.0.32&charset=utf8mb4"
        echo.
        echo # Mailer ^(for development^)
        echo MAILER_DSN=smtp://localhost:1025
        echo.
        echo # Application URL
        echo APP_URL=http://localhost:8000
        echo.
        echo # Application Secret ^(required for remember_me^)
        echo APP_SECRET=%SECRET%
        echo.
        echo ###^< Authentication System Configuration ###
    ) > .env.local
    
    echo [OK] .env.local created with random APP_SECRET
    echo [WARNING] Please update DATABASE_URL in .env.local with your database credentials
) else (
    echo Step 2: .env.local already exists, skipping...
    echo [WARNING] Make sure these variables are set:
    echo    - APP_SECRET
    echo    - APP_URL
    echo    - MAILER_DSN
    echo    - DATABASE_URL
)
echo.

REM Step 3: Run migrations
echo Step 3: Running database migrations...
set /p MIGRATE="Run migrations now? (y/n): "
if /i "%MIGRATE%"=="y" (
    call php bin/console doctrine:migrations:migrate --no-interaction
    if %errorlevel% neq 0 (
        echo [ERROR] Migration failed - check your database configuration
        exit /b 1
    )
    echo [OK] Migrations applied successfully
) else (
    echo [WARNING] Skipping migrations - run manually: php bin/console doctrine:migrations:migrate
)
echo.

REM Step 4: Install npm dependencies
echo Step 4: Installing npm dependencies...
if exist package.json (
    call npm install
    if %errorlevel% neq 0 (
        echo [ERROR] npm install failed
        exit /b 1
    )
    echo [OK] npm dependencies installed
) else (
    echo [WARNING] package.json not found, skipping npm install
)
echo.

REM Step 5: Build assets
echo Step 5: Building frontend assets...
if exist package.json (
    call npm run dev
    if %errorlevel% neq 0 (
        echo [ERROR] Asset build failed
        exit /b 1
    )
    echo [OK] Assets built successfully
) else (
    echo [WARNING] package.json not found, skipping asset build
)
echo.

REM Step 6: Clear cache
echo Step 6: Clearing cache...
call php bin/console cache:clear
if %errorlevel% neq 0 (
    echo [ERROR] Cache clear failed
)
echo [OK] Cache cleared
echo.

REM Final instructions
echo ================================
echo Setup Complete!
echo ================================
echo.
echo Next steps:
echo.
echo 1. Start Mailpit (for email testing):
echo    docker run -d -p 1025:1025 -p 8025:8025 axllent/mailpit
echo    View emails at: http://localhost:8025
echo.
echo 2. Start Symfony server:
echo    symfony server:start
echo    or: php -S localhost:8000 -t public/
echo.
echo 3. Test the authentication system:
echo    - Registration: http://localhost:8000/register
echo    - Login: http://localhost:8000/login
echo    - Password Reset: http://localhost:8000/reset-password
echo.
echo 4. Run tests:
echo    php bin/phpunit tests/Controller/AuthenticationFlowTest.php
echo.
echo Documentation:
echo    - Quick Start: SETUP_AUTH.md
echo    - Reference: AUTHENTICATION.md
echo    - Complete Guide: docs/auth.md
echo.
echo Happy coding!
echo.
pause
