<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Add SMTP configuration fields to User table
 */
final class Version20250117130000 extends AbstractMigration
{
    public function getDescription(): string
    {
        return 'Add SMTP configuration fields to user table for per-user email settings';
    }

    public function up(Schema $schema): void
    {
        // Add SMTP configuration columns to user table
        $this->addSql('ALTER TABLE `user` ADD smtp_host VARCHAR(255) DEFAULT NULL');
        $this->addSql('ALTER TABLE `user` ADD smtp_port INT DEFAULT NULL');
        $this->addSql('ALTER TABLE `user` ADD smtp_encryption VARCHAR(10) DEFAULT NULL');
        $this->addSql('ALTER TABLE `user` ADD smtp_username VARCHAR(255) DEFAULT NULL');
        $this->addSql('ALTER TABLE `user` ADD smtp_password LONGTEXT DEFAULT NULL');
        $this->addSql('ALTER TABLE `user` ADD smtp_from_email VARCHAR(255) DEFAULT NULL');
        $this->addSql('ALTER TABLE `user` ADD smtp_from_name VARCHAR(255) DEFAULT NULL');
    }

    public function down(Schema $schema): void
    {
        // Remove SMTP configuration columns from user table
        $this->addSql('ALTER TABLE `user` DROP smtp_host');
        $this->addSql('ALTER TABLE `user` DROP smtp_port');
        $this->addSql('ALTER TABLE `user` DROP smtp_encryption');
        $this->addSql('ALTER TABLE `user` DROP smtp_username');
        $this->addSql('ALTER TABLE `user` DROP smtp_password');
        $this->addSql('ALTER TABLE `user` DROP smtp_from_email');
        $this->addSql('ALTER TABLE `user` DROP smtp_from_name');
    }
}
